local t = Def.ActorFrame {};

t[#t+1] = Def.ActorFrame {
	Def.Sprite {
		Texture=THEME:GetPathG("ScreenHeader", "bg shade");
		InitCommand=function(self)
			self:x(SCREEN_LEFT):y(SCREEN_TOP):horizalign(left):vertalign(top):zoomto(SCREEN_WIDTH,64)
			self:visible(STATSMAN:GetCurStageStats():OnePassed())
		end;
		OnCommand=function(self) self:addy(-160):decelerate(0.6):addy(160) end;
		OffCommand=function(self) self:sleep(0.15):smooth(1):addy(-160) end;
	};		
	Def.Sprite {
		Texture="_shade fail";
		InitCommand=function(self)
			self:x(SCREEN_LEFT):y(SCREEN_TOP):horizalign(left):vertalign(top):zoomto(SCREEN_WIDTH,64)
			self:visible(not STATSMAN:GetCurStageStats():OnePassed())
		end;
		OnCommand=function(self) self:addy(-160):decelerate(0.6):addy(160) end;
		OffCommand=function(self) self:sleep(0.15):smooth(1):addy(-160) end;
	};	
	Def.Sprite {
		Texture=THEME:GetPathG("ScreenHeader", "left cap");
		InitCommand=function(self)
			self:x(SCREEN_LEFT):y(SCREEN_TOP):horizalign(left):vertalign(top)
		end;
		OnCommand=function(self) self:addy(-160):decelerate(0.6):addy(160) end;
		OffCommand=function(self) self:sleep(0.15):smooth(1):addy(-160) end;
	};		
	Def.Sprite {
		Texture=THEME:GetPathG("ScreenHeader", "right cap");
		InitCommand=function(self)
			self:x(SCREEN_RIGHT):y(SCREEN_TOP):horizalign(right):vertalign(top)
		end;
		OnCommand=function(self) self:addy(-160):decelerate(0.6):addy(160) end;
		OffCommand=function(self) self:sleep(0.15):smooth(1):addy(-160) end;
	};
	Def.Sprite {
		Texture=THEME:GetPathG("ScreenHeader", "tile lines");
		InitCommand=function(self)
			self:customtexturerect(0,0,1*6,1):vertalign(top):zoomto(SCREEN_WIDTH,64):x(SCREEN_CENTER_X):y(SCREEN_TOP+64)
			self:visible(STATSMAN:GetCurStageStats():OnePassed())
		end;
		OnCommand=function(self)
			self:texcoordvelocity(-0.4,0):diffusealpha(0.6)
			self:addy(-160):decelerate(0.6):addy(160)
		end;
		OffCommand=function(self) self:sleep(0.15):smooth(1):addy(-160) end;
	};	
	Def.Sprite {
		Texture="_header fail";
		InitCommand=function(self)
			self:customtexturerect(0,0,1*6,1):vertalign(top):zoomto(SCREEN_WIDTH,64):x(SCREEN_CENTER_X):y(SCREEN_TOP+64)
			self:visible(not STATSMAN:GetCurStageStats():OnePassed())
		end;
		OnCommand=function(self)
			self:texcoordvelocity(-0.4,0):diffusealpha(0.8)
			self:addy(-160):decelerate(0.6):addy(160)
		end;
		OffCommand=function(self) self:sleep(0.15):smooth(1):addy(-160) end;
	};
};

t[#t+1] = LoadFont("_exo 2 32px") .. {
		Name="HeaderText";
			InitCommand=function(self)
				self:x(SCREEN_LEFT+60):y(SCREEN_TOP+20):horizalign(left):vertalign(top):zoom(0.75):maxwidth(SCREEN_WIDTH*0.65)
			end;
			OnCommand=function(self) 
			self:playcommand("Set")
			if STATSMAN:GetCurStageStats():OnePassed() == true then
				self:diffuse(color("#26BF99"))
				else
				self:diffuse(color("#F66969"))				
			end;
			self:addy(-160):decelerate(0.6):addy(160) end;
			OffCommand=function(self) self:sleep(0.05):linear(0.1):diffusealpha(0) end;
			SetCommand=function(self)
				if STATSMAN:GetCurStageStats():OnePassed() == true then
					self:settext(string.upper(Screen.String("StageCleared")))
				else
					self:settext(string.upper(Screen.String("StageFailed")))
				end;
			end;
			UpdateScreenHeaderMessageCommand=function(self,param)
				self:settext(param.Header);
			end;
	};
	
t[#t+1] = Def.Sprite {
		Texture="_icon";
		InitCommand=function(self)
			self:x(SCREEN_LEFT+18):y(SCREEN_TOP+31):horizalign(left):vertalign(middle)
		end;
		OnCommand=function(self) 
		if STATSMAN:GetCurStageStats():OnePassed() == true then
			self:diffuse(color("#26BF99"))
			else
			self:diffuse(color("#F66969"))				
		end;
		self:addy(-160):decelerate(0.6):addy(160) end;
		OffCommand=function(self) self:sleep(0.05):linear(0.1):diffusealpha(0) end;	
};	
return t;